/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.problem;

import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemFilter;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class FruFilterReplaceDate
implements ProblemFilter {
    private static final String TRACE_MASKT = "XPAPNPFT";
    private static final String TRACE_MASKF = "XPAPNPFF";
    private static final String TRACE_MASKD = "XPAPNPFD";
    Object filterSystem = null;
    String Fru = null;
    Problem problem = null;
    private Problem referenceProblem;
    static final Comparator DECENDING_ORDER = new Comparator(){

        public int compare(Object o1, Object o2) {
            int cmp = 0;
            Problem si1 = (Problem)o1;
            Problem si2 = (Problem)o2;
            cmp = si1.getProblemTimeStamp() > si2.getProblemTimeStamp() ? -1 : (si1.getProblemTimeStamp() == si2.getProblemTimeStamp() ? 0 : 1);
            return cmp;
        }
    };

    public FruFilterReplaceDate(String Fru2, Problem problem, Object filterSystem) {
        Trace.trace(TRACE_MASKD, "<-> ctor");
        this.Fru = Fru2;
        this.problem = problem;
        this.filterSystem = filterSystem;
    }

    public void filter(List theReturnList, List theProblems) {
        Trace.trace(TRACE_MASKF, "<-> filter");
        Trace.trace(TRACE_MASKF, "looking for the last problem that contains Fru:");
        if (this.filterSystem != null) {
            Trace.trace(TRACE_MASKF, "                  Fru: " + this.Fru);
            Trace.trace(TRACE_MASKF, "current problemNumber: " + this.problem.getProblemNumber());
            Trace.trace(TRACE_MASKF, "            on system: " + this.filterSystem);
        } else {
            Trace.trace(TRACE_MASKF, "system wasn't set!!!!");
        }
        theReturnList.clear();
        PASystem problemSystem = null;
        ArrayList copyList = new ArrayList(theProblems);
        Collections.sort(copyList, DECENDING_ORDER);
        Iterator problemIter = copyList.iterator();
        block0: while (problemIter.hasNext() && theReturnList.size() == 0) {
            CommonProblem listProblem = (CommonProblem)problemIter.next();
            problemSystem = listProblem.getFailingSystem();
            if (problemSystem == null || !((Object)problemSystem).equals(this.filterSystem) || this.problem.getProblemNumber() == listProblem.getProblemNumber() || this.problem.getProblemTimeStamp() <= listProblem.getProblemTimeStamp() || listProblem.getProblemNumber() <= 0) continue;
            Trace.trace(TRACE_MASKD, "looking at problem number: " + listProblem.getProblemNumber() + " for Fru: " + this.Fru);
            List parts = listProblem.getParts();
            if (parts == null) continue;
            Trace.trace(TRACE_MASKF, "parts.size() = " + parts.size());
            for (int i = 0; i < parts.size(); ++i) {
                CommonPaFru paFru = (CommonPaFru)parts.get(i);
                Trace.trace(TRACE_MASKF, "paFru.getPartNumber[" + paFru.getPartNumber() + "]");
                if (!this.Fru.equals(paFru.getPartNumber()) || paFru.getReplacedTimeStamp() <= 0L) continue;
                Trace.trace(TRACE_MASKF, "got a match on fru and ReplacedTimeStamp");
                theReturnList.add(listProblem);
                continue block0;
            }
        }
    }

    public void setProblem(Problem theProblem) {
        this.referenceProblem = theProblem;
    }

    public Problem getProblem() {
        return this.referenceProblem;
    }
}

